//
//  MCPreferencePaneRegistry.h
//  BIViews
//
//  Created by Alykhan Jetha on 10-03-17.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCPreferencePaneRegistry : NSObject {

}


/*!
 Registers a preference pane by classname. Preferences panes are loaded only when the preference is first displayed. A preference pane must be a subclass of MCPreferencePane. Register the preferences in the order you want them displayed. All preferences must be registered before displaying the preferences window.
 */
+ (void)registerPreferencePane:(NSString *)aPreferencePaneSubclassName;

/*!
 Calls registerPreferencePane for each in the passed in array
 */
+ (void)registerPreferencePanes:(NSArray *)classNames;

/*!
 Returns the names of the preference panes in the order they where registered
 */
+ (NSArray *)preferencePaneNames;

/*!
 Used when the preference pane controller is in an unknown state
 */
+ (void)setPreferencePaneMinimumWidth:(CGFloat)w;
+ (CGFloat)preferencePaneMininumWidth;
+ (void)setPreferencePaneMinimumHeight:(CGFloat)w;
+ (CGFloat)preferencePaneMinimumHeight;

@end
